## Редактирование профиля пользователя

Контроллер Profile позволяет авторизованным пользователям редактировать свои профили, в том числе менять пароль.

При изменении профиля следует проверять уникальность email. В контроллере предусмотрено соответствующее правило:
```
&rules=`{
    "email":{
        "required":"Введите email",
        "email":"Неверный email",
        "custom":{
            "function":"\\FormLister\\Profile::uniqueEmail",
            "message":"Этот email уже использует другой пользователь"
        }
    }
}`
```
Аналогично с полем username:
```
&rules=`{
    "username":{
        "required":"Введите имя пользователя",
        "alphaNumeric":"Только буквы и цифры",
        "custom":{
            "function":"\\FormLister\\Profile::uniqueUsername",
            "message":"Имя уже занято"
        }
    }
}`
```

Если поле с паролем пустое, то пароль остается прежний. После изменения пароля пользователь должен авторизоваться с новым паролем. Новый пароль сохраняется в поле user.password.


## Параметры
### model
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### modelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### allowedFields
Разрешенные для обработки поля. Поля, не указанные в списке, игнорируются. Если пользователь меняет пароль, то в разрешенные поля добавляется поле password. Если у пользователей совпадают поля e-mail и username, то при изменении e-mail будет изменено и поле username, если значение этого поля не задано. В этом случае поле username будет добавлено в список разрешенных.

Если не задано, то разрешены все поля.

Возможные значения - имена полей формы, разделенные запятой. 

Значение по умолчанию - пусто.

### forbiddenFields
Запрещенные для обработки поля. Поля, указанные в списке, игнорируются. Поля password и username исключаются из списка по аналогии с allowedFields.

Возможные значения - имена полей формы, разделенные запятой. 

Значение по умолчанию - пусто.

### preparePostProcess
Позволяет выполнить обработку данных после сохранения.

Возможные значения - имена сниппетов, анонимные функции, статические методы загруженных классов.

Значение по умолчанию - пусто.

### redirectTo
Перенаправляет пользователя на указанную страницу после сохранения профиля.

Возможные значения - id целевой страницы.

Значение по умолчанию - пусто.

### exitTo
Перенаправляет неавторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### skipTpl
Шаблон сообщения для неавторизованного пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Profile с ключом [+profile.default_skipTpl+]

### successTpl
Шаблон сообщения об успешном обновлении профиля. Если не задан, то генерируется сообщение об успешном сохранении формы.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.
